# md_tools

## Installation

Download **md_tools_<x.y.z>.tar.gz** file to your linux box, and then unpack the contents

```console
tar zxvf md_tools_x.y.z.tar.gz
```

Change ownership and file mode of **md_dump** binary file

```console
chown user:group md_dump
chmod 755 md_dump
```

Check if **md_dump** can be started

```console
./md_dump --help
```

You should see the following:

```console
WATS Market Data Messages Dumper

Options marked (*) are optional
Options marked (**) are exclusive

Allowed options are:
  --help                print this help
  --version             print version number
  --local-ip arg        local IP address (**)
  --interface arg       local IP interface name (**)
  --multicast-group arg multicast group
  --port arg            multicast port
  --check-seq           for sequence numbers ordering check (*)
  --full-dump           print whole messages not only headers (*)
  --hb                  display also Heartbeats (*)
  --log arg             log file name (*)
  --every arg           print info with number of received messages so far
                        every specified count. Default is 10000, minimum is 10.
                        Usable only with --check-seq option (*)
```

Check the version

```console
./md_dump --version
```

Expected output is

```console
2.1.1 2da6b83aa2e77af14b037124c6c510543dc91380
```

## How to use md_dump

### Introduction

When starting **md_dump** tool you have to provide either local network interface IP address using **--ip** option or local network interface name with **--interface** option.
In other words you launch the tool this way:

```console
md_dump --ip x.x.x.x <other params...>
```

or this way:

```console
md_dump --interface ens1f0 <other params...>
```

When no **--log** option is used, md_dump writes to the standard output. In day to day operations it is recomended to use **--log** option.
md_dump stops after receiving TradingSessionStatus message with tradingSessionEvent set to EndOfTechnicalSession.

### Full dump of market data channel 11 with no Heartbeats shown in the log

```console
md_dump --interface <your local interface name> --multicast-group 233.1.3.1 --port 31001 --full-dump --log <your log file name>
```

### Full dump of market data channel 11 with Heartbeats shown in the log

```console
md_dump --interface <your local interface name> --multicast-group 233.1.3.1 --port 31001 --full-dump --hb --log <your log file name>
```

### Check if there are some loses in received stream

```console
md_dump --interface <your local interface name> --multicast-group 233.1.3.1 --port 31001 --check-seq --every=10000 --log <your log file name>
```

In that case, md_dump writes following messages into the log:

```console
10'000 messages received so far
20'000 messages received so far
30'000 messages received so far
40'000 messages received so far
```

If some messages are lost, you will see something like:

```console
Out of sync message. Expected seqNum 128821, received seqNum 128917, 96 messages lost
Out of sync message. Expected seqNum 129115, received seqNum 129126, 11 messages lost
```

